<?php
require_once '../config/config.php';
require_once '../includes/security.php';
require_once '../includes/authorization.php';

requireLogin();

Authorization::requirePageAccess('customers', 'okuma');

$error_message = '';
$customer_id = $_GET['id'] ?? null;

if (!$customer_id) {
    header('Location: customers.php');
    exit();
}

try {
    $sql = "SELECT * FROM cariler WHERE cari_id = ?";
    $customer = $database->fetch($sql, [$customer_id]);
    
    if (!$customer) {
        throw new Exception('Cari bulunamadı.');
    }
    
    $sql = "SELECT ch.*, s.satis_tarihi 
            FROM cari_hareketler ch 
            LEFT JOIN satislar s ON ch.satis_id = s.satis_id 
            WHERE ch.cari_id = ? 
            ORDER BY ch.tarih DESC";
    $movements = $database->fetchAll($sql, [$customer_id]);
    
    $sql = "SELECT s.*, u.kullanici_adi 
            FROM satislar s 
            LEFT JOIN kullanicilar u ON s.kullanici_id = u.kullanici_id 
            WHERE s.cari_id = ? 
            ORDER BY s.satis_tarihi DESC";
    $sales = $database->fetchAll($sql, [$customer_id]);
    
} catch (Exception $e) {
    $error_message = $e->getMessage();
}

include '../includes/header.php';
?>


<?php include '../includes/sidebar.php'; ?>


<div class="main-content">
    <style>
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 1rem 1.5rem;
        }
        .table th {
            background-color: #f8f9fa;
            border-top: none;
            font-weight: 600;
            color: #495057;
        }
        .badge-success { background-color: #28a745; }
        .badge-warning { background-color: #ffc107; color: #212529; }
        .badge-danger { background-color: #dc3545; }
        .badge-info { background-color: #17a2b8; }
    </style>
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-user me-2"></i>Cari Detay</h2>
                    <a href="customers.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Geri Dön
                    </a>
                </div>

                <?php if ($error_message): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <?php echo htmlspecialchars($error_message); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if (isset($customer)): ?>
                    
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Cari Bilgileri</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-borderless">
                                        <tr>
                                            <td><strong>Cari Adı:</strong></td>
                                            <td><?php echo htmlspecialchars($customer['cari_adi']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Firma Adı:</strong></td>
                                            <td><?php echo htmlspecialchars($customer['firma_adi'] ?? '-'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Telefon:</strong></td>
                                            <td><?php echo htmlspecialchars($customer['telefon'] ?? '-'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>E-posta:</strong></td>
                                            <td><?php echo htmlspecialchars($customer['email'] ?? '-'); ?></td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-borderless">
                                        <tr>
                                            <td><strong>Cari Tipi:</strong></td>
                                            <td>
                                                <span class="badge <?php echo $customer['cari_tipi'] === 'musteri' ? 'badge-success' : 'badge-info'; ?>">
                                                    <?php echo ucfirst($customer['cari_tipi']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Vergi No:</strong></td>
                                            <td><?php echo htmlspecialchars($customer['vergi_no'] ?? '-'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Bakiye:</strong></td>
                                            <td>
                                                <span class="badge <?php echo $customer['bakiye'] >= 0 ? 'badge-success' : 'badge-danger'; ?>">
                                                    ₺<?php echo number_format($customer['bakiye'] ?? 0, 2); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Kayıt Tarihi:</strong></td>
                                            <td><?php echo date('d.m.Y H:i', strtotime($customer['olusturulma_tarihi'])); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            <?php if (!empty($customer['adres'])): ?>
                                <div class="row mt-3">
                                    <div class="col-12">
                                        <strong>Adres:</strong><br>
                                        <?php echo nl2br(htmlspecialchars($customer['adres'])); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fas fa-shopping-cart me-2"></i>Satış Geçmişi</h5>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($sales)): ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Satış ID</th>
                                                <th>Tarih</th>
                                                <th>Toplam Tutar</th>
                                                <th>Ödenen</th>
                                                <th>Kalan</th>
                                                <th>Kullanıcı</th>
                                                <th>Durum</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($sales as $sale): ?>
                                                <tr>
                                                    <td>#<?php echo $sale['satis_id']; ?></td>
                                                    <td><?php echo date('d.m.Y H:i', strtotime($sale['satis_tarihi'])); ?></td>
                                                    <td>₺<?php echo number_format($sale['toplam_tutar'], 2); ?></td>
                                                    <td>₺<?php echo number_format($sale['odenen_tutar'] ?? 0, 2); ?></td>
                                                    <td>₺<?php echo number_format($sale['kalan_tutar'] ?? 0, 2); ?></td>
                                                    <td><?php echo htmlspecialchars($sale['kullanici_adi'] ?? '-'); ?></td>
                                                    <td>
                                                        <?php 
                                                        $kalan = $sale['kalan_tutar'] ?? 0;
                                                        if ($kalan <= 0): ?>
                                                            <span class="badge badge-success">Ödendi</span>
                                                        <?php elseif ($kalan < $sale['toplam_tutar']): ?>
                                                            <span class="badge badge-warning">Kısmi Ödeme</span>
                                                        <?php else: ?>
                                                            <span class="badge badge-danger">Ödenmedi</span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">Henüz satış kaydı bulunmuyor.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Cari Hareketler</h5>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($movements)): ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Tarih</th>
                                                <th>Hareket Tipi</th>
                                                <th>Tutar</th>
                                                <th>Açıklama</th>
                                                <th>Satış ID</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($movements as $movement): ?>
                                                <tr>
                                                    <td><?php echo date('d.m.Y H:i', strtotime($movement['tarih'])); ?></td>
                                                    <td>
                                                        <?php if ($movement['hareket_tipi'] === 'borc'): ?>
                                                            <span class="badge badge-danger">Borç</span>
                                                        <?php else: ?>
                                                            <span class="badge badge-success">Alacak</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <span class="<?php echo $movement['hareket_tipi'] === 'borc' ? 'text-danger' : 'text-success'; ?>">
                                                            ₺<?php echo number_format($movement['tutar'], 2); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo htmlspecialchars($movement['aciklama'] ?? '-'); ?></td>
                                                    <td>
                                                        <?php if ($movement['satis_id']): ?>
                                                            #<?php echo $movement['satis_id']; ?>
                                                        <?php else: ?>
                                                            -
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">Henüz hareket kaydı bulunmuyor.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
</div>

<?php include '../includes/footer.php'; ?>